<?php
	// Class for Advanced Textblock Element
    if (!class_exists('TS_VCSC_TextBlock_Highlights_Element')){
        class TS_VCSC_TextBlock_Highlights_Element {
            function __construct() {
                global $VISUAL_COMPOSER_EXTENSIONS;
                if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VCFrontEditMode == "true") {
                    if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
                        $this->TS_VCSC_Highlighted_Textblock_Lean();
                    } else if (function_exists('vc_map')) {
                        add_action('init',                                  array($this, 'TS_VCSC_Highlighted_Textblock_Element'), 9999999);
                    }
                } else {
                    if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
                        add_action('admin_init',							array($this, 'TS_VCSC_Highlighted_Textblock_Lean'), 9999999);
                    } else if (function_exists('vc_map')) {
                        add_action('admin_init',							array($this, 'TS_VCSC_Highlighted_Textblock_Element'), 9999999);
                    }
                }
                if ((is_admin() == false) || ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VCFrontEditMode == "true") || ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_PluginAJAX == "true") || ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_PluginAlways == "true")) {                    
                    // Load DOM HTML Parser
                    if (!class_exists('simple_html_dom_node')) {
                        require_once($VISUAL_COMPOSER_EXTENSIONS->domparser_dir . 'simple_html_dom.php');
                    }
                    // Register Shortcode
                    add_shortcode('TS_VCSC_Highlighted_Textblock',          array($this, 'TS_VCSC_Highlighted_Textblock_Function'));
                }           
            }
            
            // Register Element(s) via LeanMap
            function TS_VCSC_Highlighted_Textblock_Lean() {
                vc_lean_map('TS_VCSC_Highlighted_Textblock',                array($this, 'TS_VCSC_Highlighted_Textblock_Element'), null);
            }
            
            // Callback for Layout Markup
            function TS_VCSC_Highlighted_Textblock_Layout($content_layout, $content_shift) {
                $output = '';
                if ($content_layout == "circleline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M325,18C228.7-8.3,118.5,8.3,78,21C22.4,38.4,4.6,54.6,5.6,77.6c1.4,32.4,52.2,54,142.6,63.7 c66.2,7.1,212.2,7.5,273.5-8.3c64.4-16.6,104.3-57.6,33.8-98.2C386.7-4.9,179.4-1.4,126.3,20.7"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "curlyline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M3,146.1c17.1-8.8,33.5-17.8,51.4-17.8c15.6,0,17.1,18.1,30.2,18.1c22.9,0,36-18.6,53.9-18.6 c17.1,0,21.3,18.5,37.5,18.5c21.3,0,31.8-18.6,49-18.6c22.1,0,18.8,18.8,36.8,18.8c18.8,0,37.5-18.6,49-18.6c20.4,0,17.1,19,36.8,19 c22.9,0,36.8-20.6,54.7-18.6c17.7,1.4,7.1,19.5,33.5,18.8c17.1,0,47.2-6.5,61.1-15.6"></path>';                     
                    $output .= '</svg>';
                } elseif ($content_layout == "topbottomline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M8.4,143.1c14.2-8,97.6-8.8,200.6-9.2c122.3-0.4,287.5,7.2,287.5,7.2"></path>';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)" "' : '') . ' d="M8,19.4c72.3-5.3,162-7.8,216-7.8c54,0,136.2,0,267,7.8"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "doubleline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M5,125.4c30.5-3.8,137.9-7.6,177.3-7.6c117.2,0,252.2,4.7,312.7,7.6"></path>';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M26.9,143.8c55.1-6.1,126-6.3,162.2-6.1c46.5,0.2,203.9,3.2,268.9,6.4"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "strikethroughline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M3,75h493.5"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "zigzagline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M9.3,127.3c49.3-3,150.7-7.6,199.7-7.4c121.9,0.4,189.9,0.4,282.3,7.2C380.1,129.6,181.2,130.6,70,139 c82.6-2.9,254.2-1,335.9,1.3c-56,1.4-137.2-0.3-197.1,9"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "diagonalline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M13.5,15.5c131,13.7,289.3,55.5,475,125.5"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "underline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M7.7,145.6C109,125,299.9,116.2,401,121.3c42.1,2.2,87.6,11.8,87.3,25.7"></path>';
                    $output .= '</svg>';
                } elseif ($content_layout == "crossoutline") {
                    $output .= '<svg class="ts-textblock-highlighted-text-line" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 150" preserveAspectRatio="none">';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M497.4,23.9C301.6,40,155.9,80.6,4,144.4"></path>';
                        $output .= '<path ' . ($content_shift == "to left" ? 'transform="scale(-1, 1) translate(-500, 0)"' : '') . ' d="M14.1,27.6c204.5,20.3,393.8,74,467.3,111.7"></path>';
                    $output .= '</svg>';
                }
                return $output;
            }
            
            // Output of Highlighted Textblock Element
            function TS_VCSC_Highlighted_Textblock_Function($atts, $content = null) {
                global $VISUAL_COMPOSER_EXTENSIONS;
                ob_start();
                
				if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VCFrontEditMode == "true") {
					$block_frontend         = "true";
				} else {
					$block_frontend         = "false";
				}
                
                extract(shortcode_atts(array(
                    // Content Settings
                    'content_tinymce'       => '',
                    // Style Settings
                    'styling_color'         => '#696969',
                    'styling_weight'        => 'normal',
                    'styling_style'         => 'normal',
                    'styling_decoration'    => 'none',
                    'styling_align'         => 'center',
                    'styling_transform'     => 'none',
                    'styling_family'        => 'Default:regular',
                    'styling_font'          => 'default',
                    'styling_size'          => 14,
                    'styling_linetype'      => 'relative',
                    'styling_linerelative'  => 140,
                    'styling_linefixedpx'   => 36,
                    'styling_indent'        => 0,     
                    // Marker Settings
                    'marker_color'          => '#fff300',
                    'marker_shift'          => 'to right',
                    'marker_cycle'          => 5000,
                    'marker_count'          => 0,
                    // Stroke Settings
                    'stroke_color'          => '#8a0000',
                    'stroke_shift'          => 'to right',
                    'stroke_width'          => 10,
                    'stroke_cycle'          => 5000,
                    'stroke_count'          => 0,
                    // Highlight Settings
                    'focus_custom'          => 'false',
                    'focus_color'           => '#696969',
                    'focus_weight'          => 'inherit',
                    'focus_style'           => 'inherit',
                    'focus_decoration'      => 'inherit',
                    'focus_transform'       => 'inherit',
                    'focus_family'          => 'Default:regular',
                    'focus_font'            => 'default',
                    'focus_size'            => 30,
					// Conditional Output
					'conditionals'          => '',
                    // Other Settings
                    'margin_top'            => 0,
                    'margin_bottom'         => 0,
                    'el_id'                 => '',
                    'el_class'              => '',
                    'css'                   => '',
                ), $atts));
                
				// Check Conditional Output
				$render_conditionals        = (empty($conditionals) ? true : TS_VCSC_CheckConditionalOutput($conditionals));
				if (!$render_conditionals) {
					$myvariable             = ob_get_clean();
					return $myvariable;
				}
                
                // Load Required JS/CSS Files
                wp_enqueue_style('ts-extend-textblocks');
              
                // Declare Variables
                $randomizer                 = TS_VCSC_CreateRandomAlphaNumericString();
                $output                     = '';      
                $style_wrapper              = '';
                $style_header               = '';
                $style_title                = '';
                $style_marker               = '';
                $style_stroke               = '';
                $style_inline               = TS_VCSC_FrontendAppendCustomRules('style');
                $styles_output              = '';
              
                // Element ID
                if (!empty($el_id)) {
                    $textbox_id             = $el_id;
                } else {
                    $textbox_id             = 'ts-highlighted-title-wrapper-' . $randomizer;
                }
              
                // WP Bakery Page Builder CSS Override
                if (function_exists('vc_shortcode_custom_css_class')) {
                    $css_class              = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, ' ' . vc_shortcode_custom_css_class($css, ' '), 'TS_VCSC_Title_Highlighted', $atts);
                } else {
                    $css_class              = '';
                }

                // Load DOM HTML Parser
                if (!class_exists('simple_html_dom_node')) {
                    require_once($VISUAL_COMPOSER_EXTENSIONS->domparser_dir . 'simple_html_dom.php');
                }
              
                // Process Content
                $content_counter           = 0;
                if (($content !== null) && ($content !== "")) {
                    $content_tinymce        = $content;
                } else {
                    $content_tinymce        = rawurldecode(base64_decode(strip_tags($content_tinymce)));
                }
                $content_html               = str_get_html($content_tinymce);
                $content_markup             = '';
                $content_output             = '';
                $content_header             = count($content_html->find('div,p,h1,h2,h3,h4,h5,h6'));
                $content_output .= '<div id="' . $textbox_id . '" class="ts-textblock-highlighted-wrapper ' . $css_class . '" data-randomizer="' . $randomizer . '">';
                    $content_output .= '<div class="ts-textblock-highlighted-container">';
                        // Mark all Block-Elements as Header Elements
                        if ($content_header > 0) {                   
                            foreach($content_html->find('div,p,h1,h2,h3,h4,h5,h6') as $headers) {
                                $headers->class                 = 'ts-textblock-highlighted-header'; 
                            }
                        }
                        // Store Highlight Styles
                        $content_highlights                     = array();
                        // Process all SPAN Highlight Elements
                        foreach($content_html->find('span[class*="ts-textblock-highlighted-layout-markup"]') as $highlight) {
                            // Extract Hightlight Layout (Markup)
                            $content_markup                     = isset($highlight->attr['data-layout']) ? $highlight->attr['data-layout'] : 'textmarker';
                            $highlight->attr['data-layout']     = null;
                            $highlight->attr['data-name']       = null;
                            // Adjust ID & Class Attrbiutes
                            $highlight->id                      = 'ts-textblock-highlighted-spotlight-holder-' . $randomizer . '-' . $content_counter;
                            $highlight->class                   = null;
                            // Adjust HTML Output
                            if ($content_markup == "textmarker") {
                               $highlight->class                = 'ts-textblock-highlighted-spotlight-holder ts-textblock-highlighted-spotlight-marker';
                               $highlight->innertext            = '<span class="ts-textblock-highlighted-text-string">' . $highlight->innertext. '</span><span class="ts-textblock-highlighted-text-marker" data-direction="' . $marker_shift . '"></span>';
                            } else {
                               $highlight->class                = 'ts-textblock-highlighted-spotlight-holder ts-textblock-highlighted-spotlight-lines';
                               $highlight->innertext            = '<span class="ts-textblock-highlighted-text-string">' . $highlight->innertext. '</span>' . $this->TS_VCSC_Highlighted_Textblock_Layout($content_markup, $stroke_shift);
                            }
                            // Store Highlight Custom Styling
                            $content_highlights[]               = array(
                               'counter'                        => $content_counter,
                               'markup'                         => $content_markup,
                               'styles'                         => $highlight->style,
                            );
                            $highlight->style                   = null;
                            // Increase Counter
                            $content_counter++;
                        }
                        if ($content_header == 0) {
                            $content_output .= '<div class="ts-textblock-highlighted-header">';
                        }
                            $content_output .= $content_html;
                        if ($content_header == 0) {
                            $content_output .= '</div>';
                        }
                    $content_output .= '</div>';
                $content_output .= '</div>';
                // Prevent Memory Leaks
                $content_html->clear();
                unset($content_html);
        
                // Conditional Checks
                if ($stroke_count == 0) {
                    $stroke_count           = 'infinite';
                }
                if ($marker_count == 0) {
                    $marker_count           = 'infinite';
                }
              
                // Retrieve Custom Font		
                if (strpos($styling_family, 'Default') === false) {
                    $font_default           = TS_VCSC_GetFontFamily($textbox_id, $styling_family, $styling_font, false, true, false);
                } else {
                    $font_default           = '';
                }
              
                // Create Default Styling	
                if ($style_inline == "false") {
                    $styles_output .= '<style id="' . $textbox_id . '-style" type="text/css">';
                }
                    $styles_output .= 'body #' . $textbox_id . '.ts-textblock-highlighted-wrapper {';
                        $styles_output .= 'margin-top: ' . $margin_top . 'px; margin-bottom: ' . $margin_bottom . 'px;';
                    $styles_output .= '}';
                    $styles_output .= 'body #' . $textbox_id . '.ts-textblock-highlighted-wrapper .ts-textblock-highlighted-container .ts-textblock-highlighted-header {';
                        $styles_output .= $font_default;
                        $styles_output .= 'color: ' . $styling_color . ';';
                        $styles_output .= 'font-size: ' . $styling_size . 'px;';
                        $styles_output .= 'font-style: ' . $styling_style . ';';
                        if ($styling_linetype == 'relative') {
                            $styles_output .= 'line-height: ' . ($styling_linerelative / 100) . ';';
                        } else if ($styling_linetype == 'fixedpx') {
                            $styles_output .= 'line-height: ' . $styling_linefixedpx . 'px;';
                        }
                        $styles_output .= 'font-weight: ' . $styling_weight . ';';
                        $styles_output .= 'text-align: ' . $styling_align . ';';
                        $styles_output .= 'text-transform: ' . $styling_transform . ';';
                        $styles_output .= 'text-decoration: ' . $styling_decoration . ';';
                        $styles_output .= 'text-indent: ' . $styling_indent .'px;';
                    $styles_output .= '}';
                    foreach($content_highlights as $highlight) {
                        $content_layout         = (isset($highlight['markup']) ? $highlight['markup'] : '');
                        $content_counter        = (isset($highlight['counter']) ? $highlight['counter'] : 0);
                        // Retrieve Highlight Styles
                        $content_styles         = (isset($highlight['styles']) ? $highlight['styles'] : '');
                        $content_styles         = str_replace("; ", ";", $content_styles);
                        $content_styles         = rtrim($content_styles, ';');
                        $content_styles         = explode(";", $content_styles);
                        $content_splits         = array();
                        foreach($content_styles as &$styles) {
                            $styles              = explode(":", $styles);
                            $content_splits[trim($styles[0])] = trim($styles[1]);
                        }
                        unset($content_styles);              
                        $styles_color           = trim(isset($content_splits['color']) ? $content_splits['color'] : '');
                        $styles_font            = trim(isset($content_splits['font-family']) ? $content_splits['font-family'] : '');
                        $styles_size            = trim(isset($content_splits['font-size']) ? $content_splits['font-size'] : '');
                        $styles_decoration      = trim(isset($content_splits['text-decoration']) ? $content_splits['text-decoration'] : '');
                        // Style: Text String
                        $styles_output .= 'body #' . $textbox_id . '.ts-textblock-highlighted-wrapper .ts-textblock-highlighted-container .ts-textblock-highlighted-header #ts-textblock-highlighted-spotlight-holder-' . $randomizer . '-' . $content_counter . ' .ts-textblock-highlighted-text-string {';
                            if ($styles_size !== "") {
                                $styles_output .= 'font-size: ' . $styles_size . ';';
                            } elseif ($focus_custom === "true") {
                                $styles_output .= 'font-size: ' . $focus_size . 'px;';
                            }
                            if ($styles_color !== "") {
                                $styles_output .= 'color: ' . $styles_color . ';';
                            } elseif ($focus_custom === "true") {
                                $styles_output .= 'color: ' . $focus_color . ';';
                            }
                            if ($styles_font !== "") {
                                $styles_output .= 'font-family: ' . $styles_font . ';';
                            } elseif (($focus_custom === "true") && (strpos($focus_family, 'Default') === false)) {
                                $styles_output .= TS_VCSC_GetFontFamily($textbox_id, $focus_family, $focus_font, false, true, false);
                            }
                            if ($styles_decoration !== "") {
                                $styles_output .= 'text-decoration: ' . $styles_decoration . ';';
                            } elseif (($focus_custom === "true") && ($focus_decoration != "none")) {
                                $styles_output .= 'text-decoration: ' . $focus_decoration . ';';
                            }
                            if ($focus_custom === "true") {
                                if ($focus_transform !== "none") {
                                    $styles_output .= 'text-transform: ' . $focus_transform . ';';
                                }
                                if ($focus_weight !== "normal") {
                                    $styles_output .= 'font-weight: ' . $focus_weight . ';';
                                }
                            }
                        $styles_output .= '}';
                        // Style: Highlight Effect
                        $styles_background      = trim(isset($content_splits['background-color']) ? $content_splits['background-color'] : ($content_layout == 'textmarker' ? $marker_color : $stroke_color));
                        if ($styles_background == "transparent") {
                            $styles_background   = ($content_layout == 'textmarker' ? $marker_color : $stroke_color);
                        }
                        if ($content_layout == "textmarker") {
                            $styles_output .= 'body #' . $textbox_id . '.ts-textblock-highlighted-wrapper .ts-textblock-highlighted-container .ts-textblock-highlighted-header #ts-textblock-highlighted-spotlight-holder-' . $randomizer . '-' . $content_counter . ' .ts-textblock-highlighted-text-marker {';
                                $styles_output .= '-webkit-background-image: linear-gradient(' . $marker_shift . ', rgba(255, 255, 255, 0) 0%, ' . $styles_background . ' 20%, rgba(255, 255, 255, 0) 100%); ';
                                $styles_output .= '-moz-background-image: linear-gradient(' . $marker_shift . ', rgba(255, 255, 255, 0) 0%, ' . $styles_background . ' 20%, rgba(255, 255, 255, 0) 100%); ';
                                $styles_output .= '-o-background-image: linear-gradient(' . $marker_shift . ', rgba(255, 255, 255, 0) 0%, ' . $styles_background . ' 20%, rgba(255, 255, 255, 0) 100%); ';
                                $styles_output .= 'background-image: linear-gradient(' . $marker_shift . ', rgba(255, 255, 255, 0) 0%, ' . $styles_background . ' 20%, rgba(255, 255, 255, 0) 100%); ';
                                $styles_output .= '-webkit-animation-iteration-count: ' . $marker_count . '; -moz-animation-iteration-count: ' . $marker_count . '; -o-animation-iteration-count: ' . $marker_count . '; animation-iteration-count: ' . $marker_count . '; ';
                                $styles_output .= '-webkit-animation-duration: ' . $marker_cycle . 'ms; -moz-animation-duration: ' . $marker_cycle . 'ms; -o-animation-duration: ' . $marker_cycle . 'ms; animation-duration: ' . $marker_cycle . 'ms; ';
                            $styles_output .= '}';
                        } elseif ($content_layout != "") {
                            $styles_output .= 'body #' . $textbox_id . '.ts-textblock-highlighted-wrapper .ts-textblock-highlighted-container .ts-textblock-highlighted-header #ts-textblock-highlighted-spotlight-holder-' . $randomizer . '-' . $content_counter . ' .ts-textblock-highlighted-text-line path {';
                                $styles_output .= 'stroke: ' . $styles_background . '; stroke-width: ' . $stroke_width . 'px; ';
                                $styles_output .= '-webkit-animation-duration: ' . $stroke_cycle . 'ms; -moz-animation-duration: ' . $stroke_cycle . 'ms; -o-animation-duration: ' . $stroke_cycle . 'ms; animation-duration: ' . $stroke_cycle . 'ms; ';
                                $styles_output .= '-webkit-animation-iteration-count: ' . $stroke_count . '; -moz-animation-iteration-count: ' . $stroke_count . '; -o-animation-iteration-count: ' . $stroke_count . '; animation-iteration-count: ' . $stroke_count . '; ';
                            $styles_output .= '}';
                        }
                    }
                if ($style_inline == "false") {
                    $styles_output .= '</style>';
                }
                if (($styles_output != "") && ($style_inline == "true")) {
                    wp_add_inline_style('ts-visual-composer-extend-custom', TS_VCSC_MinifyCSS($styles_output));
                }
              
              
                // Custom Style Rules
                if (($styles_output != "") && ($style_inline == "false")) {
                    $output .= TS_VCSC_MinifyCSS($styles_output);
                }
        
                // Final Element Output
                $output .= $content_output;
                
                // Return Output
                echo $output;
                
                // Clear Potential Memory Leaks
                unset($output);
                unset($content_output);
                unset($styles_output);
                
                $myvariable = ob_get_clean();
                return $myvariable;
            }            
			
			// Register Advanced Textblock Element
            function TS_VCSC_Highlighted_Textblock_Element() {
                global $VISUAL_COMPOSER_EXTENSIONS;
                $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element = array(
                    "name"                              => __( "TS Textblock Highlighted", "ts_visual_composer_extend" ),
                    "base"                              => "TS_VCSC_Highlighted_Textblock",
                    "icon" 	                            => "ts-composer-element-icon-highlighted-textblock",
                    "category"                          => __( "Composium", "ts_visual_composer_extend" ),
                    "description"                       => __("Place a textblock element with highlights.", "ts_visual_composer_extend"),
                    "admin_enqueue_js"        	        => "",
                    "admin_enqueue_css"       	        => "",
                    "params"                            => array(
                        // Content Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_1",
                            "seperator"					=> "Textblock Content",
                        ),
                        array(
                            "type"              	    => "messenger",
                            "heading"                   => __( "Instructions", "ts_visual_composer_extend" ),
                            "param_name"        	    => "messenger",
                            "layout"                    => "notice",
                            "color"					    => "#006BB7",
                            "size"					    => "13",
                            "message"            	    => __( "In order to highlight a text string when rendering this element on the frontend, select the text string in the text editor below first and then use the <strong>'Highlights'</strong> (or <strong>'Formats'</strong>) control in the menu bar to apply one of the available highlight types to the text string.<br><br>By further using the text color control, you can define the font color for the highlighted string. Using the background color control will define the color used for the highlight effect; the text string itself will always be shown with a transparent background.", "ts_visual_composer_extend" ),
                        ),          
                        array(
                            "type"                      => "wysiwyg_base64",
                            "heading"                   => __( "Content", "ts_visual_composer_extend" ),
                            "param_name"                => "content_tinymce",
                            "holder" 					=> "div",
                            "minimal"			        => "highlights",
                            "layouts"                   => array(
                                "textmarker"                    => __( "Text Marker", "ts_visual_composer_extend" ),
                                "circleline"                    => __( "Circled Line", "ts_visual_composer_extend" ),
                                "topbottomline"                 => __( "Top + Bottom Line", "ts_visual_composer_extend" ),                    
                                "curlyline"                     => __( "Curly Underline", "ts_visual_composer_extend" ),
                                "zigzagline"                    => __( "ZigZag Underline", "ts_visual_composer_extend" ),
                                "underline"                     => __( "Single Underline", "ts_visual_composer_extend" ),
                                "doubleline"                    => __( "Double Underline", "ts_visual_composer_extend" ),                    
                                "strikethroughline"             => __( "Strike Through Line", "ts_visual_composer_extend" ),
                                "diagonalline"                  => __( "Single Crossout Line", "ts_visual_composer_extend" ),
                                "crossoutline"                  => __( "Double Crossout Line", "ts_visual_composer_extend" ),
                            ),
                            "cssstyles"                 => $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_PluginPath . 'css/ts-visual-composer-extend-tinymce.min.css',
                            "value"                     => base64_encode(""),
                            "description"               => __( "Enter the content for the textbloxk and use the provided formatting options.", "ts_visual_composer_extend" ),
                        ),            
                        // Default Font Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_2",
                            "seperator"					=> "Content Styling",
                            "group"						=> "Content Styling",
                        ),
                        array(
                            'type' 						=> 'colorpicker',
                            'heading' 					=> __( 'Font Color', 'ts_visual_composer_extend' ),
                            'param_name' 				=> 'styling_color',
                            'value'						=> '#696969',
                            'description' 				=> __( 'Select the default font color for the element.', 'ts_visual_composer_extend' ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),										
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Font Weight", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_weight",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Normal', "ts_visual_composer_extend" )       => "normal",
                                __( 'Bolder', "ts_visual_composer_extend" )       => "bolder",			 
                                __( 'Bold', "ts_visual_composer_extend" )         => "bold",
                                __( 'Light', "ts_visual_composer_extend" )        => "300",
                                __( 'Lighter', "ts_visual_composer_extend" )      => "100",
                                __( 'Default', "ts_visual_composer_extend" )      => "inherit",
                            ),
                            "description"       		=> __( "Select the default font weight for the element.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),						
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Font Style", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_style",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Normal', "ts_visual_composer_extend" )      	=> "normal",
                                __( 'Italic', "ts_visual_composer_extend" )       	=> "italic",			 
                                __( 'Oblique', "ts_visual_composer_extend" )		=> "oblique",
                            ),
                            "description"       		=> __( "Select the default font style for the element.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),						
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Text Alignment", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_align",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Left', "ts_visual_composer_extend" )			=> "left",
                                __( 'Right', "ts_visual_composer_extend" )			=> "right",			 
                                __( 'Center', "ts_visual_composer_extend" )			=> "center",
                                __( 'Justify', "ts_visual_composer_extend" )		=> "justify",
                            ),
                            "description"       		=> __( "Select the default text alignment for the element.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),								
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Text Transform", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_transform",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'None', "ts_visual_composer_extend" )			=> "none",
                                __( 'Capitalize', "ts_visual_composer_extend" )		=> "capitalize",			 
                                __( 'Uppercase', "ts_visual_composer_extend" )		=> "uppercase",
                                __( 'Lowercase', "ts_visual_composer_extend" )		=> "lowercase",
                            ),
                            "description"       		=> __( "Select the default text transform for the element.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Text Decoration", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_decoration",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'None', "ts_visual_composer_extend" )       	=> "none",
                                __( 'Underline', "ts_visual_composer_extend" )		=> "underline",			 
                                __( 'Overline', "ts_visual_composer_extend" )		=> "overline",
                                __( 'Line Through', "ts_visual_composer_extend" )	=> "line-through",
                            ),
                            "description"       		=> __( "Select the default font decoration for the element.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "group"						=> "Content Styling",
                        ),	
                        array(
                            "type"						=> "fontsmanager",
                            "heading"					=> __( "Font Family", "ts_visual_composer_extend" ),
                            "param_name"				=> "styling_family",
                            "value"						=> "Default:regular",
                            "default"					=> "true",
                            "connector"					=> "styling_font",
                            "description"				=> __( "Select the default font family to be used for the element.", "ts_visual_composer_extend" ),
                            "group"						=> "Content Styling",
                        ),
                        array(
                            "type"						=> "hidden_input",
                            "param_name"				=> "styling_font",
                            "value"						=> "default",
                            "group"						=> "Content Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Font Size", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_size",
                            "value"             		=> "14",
                            "min"               		=> "10",
                            "max"               		=> "100",
                            "step"              		=> "1",
                            "unit"              		=> 'px',
                            "description"       		=> "Define the font size to be used for the element.",
                            "group"						=> "Content Styling",
                        ),						
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Line Height Type", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_linetype",
                            "width"             		=> 300,
                            "value"             		=> array(								
                                __( "Relative (Based on Font Size)", "ts_visual_composer_extend" )	=> "relative",
                                __( "Fixed Pixels Value", "ts_visual_composer_extend" )				=> "fixedpx",
                            ),
                            "description"       		=> __( "Select how the general line height for this element should be determined.", "ts_visual_composer_extend" ),
                            "group"						=> "Content Styling",
                        ),						
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Line Height", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_linerelative",
                            "value"             		=> "140",
                            "min"               		=> "100",
                            "max"               		=> "500",
                            "step"              		=> "1",
                            "unit"              		=> '%',
                            "description"       		=> "Define the relative line height to be used for the element; 100% equals the selected font size.",
                            "dependency"        		=> array( 'element' => "styling_linetype", 'value' => 'relative' ),
                            "group"						=> "Content Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Line Height", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_linefixedpx",
                            "value"             		=> "21",
                            "min"               		=> "12",
                            "max"               		=> "120",
                            "step"              		=> "1",
                            "unit"              		=> 'px',
                            "description"       		=> "Define the fixed line height in pixels to be used for the element.",
                            "dependency"        		=> array( 'element' => "styling_linetype", 'value' => 'fixedpx' ),
                            "group"						=> "Content Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Text Indentation", "ts_visual_composer_extend" ),
                            "param_name"        		=> "styling_indent",
                            "value"             		=> "0",
                            "min"               		=> "-100",
                            "max"               		=> "100",
                            "step"              		=> "1",
                            "unit"              		=> 'px',
                            "description"       		=> "Define the general text indentation to be used for the element.",
                            "group"						=> "Content Styling",
                        ),
                        // Highlight: Textmarker Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_3",
                            "seperator"			        => "Textmarker Styling",
                            "group" 			        => "Highlights Styling",
                        ),                        
                        array(
                            'type' 						=> 'colorpicker',
                            'heading' 					=> __( 'Textmarker: Color', 'ts_visual_composer_extend' ),
                            'param_name' 				=> 'marker_color',
                            'value'						=> '#fff300',
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            'description' 				=> __( 'Select the highlight color for the textmarker effect.', 'ts_visual_composer_extend' ),
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Textmarker: Direction", "ts_visual_composer_extend" ),
                            "param_name"        		=> "marker_shift",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Left To Right', "ts_visual_composer_extend" )      	=> "to right",
                                __( 'Right To Left', "ts_visual_composer_extend" )       	=> "to left",
                            ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "description"       		=> __( "Select the animation direction for the textmarker effect.", "ts_visual_composer_extend" ),
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),	
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Textmarker: Repeats", "ts_visual_composer_extend" ),
                            "param_name"        		=> "marker_count",
                            "value"             		=> "0",
                            "min"               		=> "0",
                            "max"               		=> "100",
                            "step"              		=> "1",
                            "unit"              		=> 'x',
                            "description"       		=> "Define how many time the textmarker effect animation should be repeated; set to zero (0) for unlimited repeats.",
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Textmarker: Duration", "ts_visual_composer_extend" ),
                            "param_name"        		=> "marker_cycle",
                            "value"             		=> "5000",
                            "min"               		=> "1000",
                            "max"               		=> "1000000",
                            "step"              		=> "100",
                            "unit"              		=> 'ms',
                            "description"       		=> "Define how long a single textmarker effect animation should last until it is repeated again.",
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),
                        // Highlight: Line Effect Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_4",
                            "seperator"			        => "Line Effects Styling",
                            "group" 			        => "Highlights Styling",
                        ),
                        array(
                            'type' 						=> 'colorpicker',
                            'heading' 					=> __( 'Lines: Color', 'ts_visual_composer_extend' ),
                            'param_name' 				=> 'stroke_color',
                            'value'						=> '#8a0000',
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            'description' 				=> __( 'Select the highlight color for the lines effect.', 'ts_visual_composer_extend' ),
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Lines: Direction", "ts_visual_composer_extend" ),
                            "param_name"        		=> "stroke_shift",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Left To Right', "ts_visual_composer_extend" )      	=> "to right",
                                __( 'Right To Left', "ts_visual_composer_extend" )       	=> "to left",
                            ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "description"       		=> __( "Select the animation direction for the lines effect.", "ts_visual_composer_extend" ),
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),                        
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Lines: Strength", "ts_visual_composer_extend" ),
                            "param_name"        		=> "stroke_width",
                            "value"             		=> "10",
                            "min"               		=> "1",
                            "max"               		=> "50",
                            "step"              		=> "1",
                            "unit"              		=> 'px',
                            "description"       		=> "Define the strength of each individual line within the line highlights.",
                            "group"						=> "Highlights Styling",
                        ),                        
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Lines: Repeats", "ts_visual_composer_extend" ),
                            "param_name"        		=> "stroke_count",
                            "value"             		=> "0",
                            "min"               		=> "0",
                            "max"               		=> "100",
                            "step"              		=> "1",
                            "unit"              		=> 'x',
                            "description"       		=> "Define how many time the lines effect animation should be repeated; set to zero (0) for unlimited repeats.",
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Lines: Duration", "ts_visual_composer_extend" ),
                            "param_name"        		=> "stroke_cycle",
                            "value"             		=> "5000",
                            "min"               		=> "1000",
                            "max"               		=> "1000000",
                            "step"              		=> "100",
                            "unit"              		=> 'ms',
                            "description"       		=> "Define how long a single lines effect animation should last until it is repeated again.",
                            "admin_label"				=> true,
                            "group"						=> "Highlights Styling",
                        ),
                        // Highlight: Font Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_5",
                            "seperator"			        => "Highlights Font",
                            "group" 			        => "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "switch_button",
                            "heading"			    	=> __( "Highlights Font", "ts_visual_composer_extend" ),
                            "param_name"		    	=> "focus_custom",
                            "value"             		=> "false",                            
                            "description"		    	=> __( "Switch the toggle if you want to apply global custom font settings to the highlighted segments of the content.", "ts_visual_composer_extend" ),
                            "group" 			        => "Highlights Styling",
                        ),
                        array(
                            'type' 						=> 'colorpicker',
                            'heading' 					=> __( 'Font Color', 'ts_visual_composer_extend' ),
                            'param_name' 				=> 'focus_color',
                            'value'						=> '#696969',
                            'description' 				=> __( 'Select the default font color for the highlighted segments.', 'ts_visual_composer_extend' ),
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),						
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Font Weight", "ts_visual_composer_extend" ),
                            "param_name"        		=> "focus_weight",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Inherit', "ts_visual_composer_extend" )        => "inherit",
                                __( 'Normal', "ts_visual_composer_extend" )         => "normal",
                                __( 'Bolder', "ts_visual_composer_extend" )         => "bolder",			 
                                __( 'Bold', "ts_visual_composer_extend" )           => "bold",
                                __( 'Light', "ts_visual_composer_extend" )          => "300",
                                __( 'Lighter', "ts_visual_composer_extend" )        => "100",                                
                            ),
                            "description"       		=> __( "Select the default font weight for the highlighted segments.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),						
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Font Style", "ts_visual_composer_extend" ),
                            "param_name"        		=> "focus_style",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Inherit', "ts_visual_composer_extend" )        => "inherit",
                                __( 'Normal', "ts_visual_composer_extend" )      	=> "normal",
                                __( 'Italic', "ts_visual_composer_extend" )       	=> "italic",			 
                                __( 'Oblique', "ts_visual_composer_extend" )		=> "oblique",
                            ),
                            "description"       		=> __( "Select the default font style for the highlighted segments.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),							
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Text Transform", "ts_visual_composer_extend" ),
                            "param_name"        		=> "focus_transform",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Inherit', "ts_visual_composer_extend" )        => "inherit",
                                __( 'None', "ts_visual_composer_extend" )			=> "none",
                                __( 'Capitalize', "ts_visual_composer_extend" )		=> "capitalize",			 
                                __( 'Uppercase', "ts_visual_composer_extend" )		=> "uppercase",
                                __( 'Lowercase', "ts_visual_composer_extend" )		=> "lowercase",
                            ),
                            "description"       		=> __( "Select the default text transform for the highlighted segments.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "dropdown",
                            "heading"           		=> __( "Text Decoration", "ts_visual_composer_extend" ),
                            "param_name"        		=> "focus_decoration",
                            "width"             		=> 300,
                            "value"             		=> array(
                                __( 'Inherit', "ts_visual_composer_extend" )        => "inherit",
                                __( 'None', "ts_visual_composer_extend" )       	=> "none",
                                __( 'Underline', "ts_visual_composer_extend" )		=> "underline",			 
                                __( 'Overline', "ts_visual_composer_extend" )		=> "overline",
                                __( 'Line Through', "ts_visual_composer_extend" )	=> "line-through",
                            ),
                            "description"       		=> __( "Select the default font decoration for the highlighted segments.", "ts_visual_composer_extend" ),
                            "edit_field_class"			=> "vc_col-sm-6 vc_column",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),	
                        array(
                            "type"						=> "fontsmanager",
                            "heading"					=> __( "Font Family", "ts_visual_composer_extend" ),
                            "param_name"				=> "focus_family",
                            "value"						=> "Default:regular",
                            "default"					=> "true",
                            "connector"					=> "focus_font",
                            "description"				=> __( "Select the default font family to be used for the highlighted segments.", "ts_visual_composer_extend" ),
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"						=> "hidden_input",
                            "param_name"				=> "focus_font",
                            "value"						=> "default",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),
                        array(
                            "type"              		=> "nouislider",
                            "heading"           		=> __( "Font Size", "ts_visual_composer_extend" ),
                            "param_name"        		=> "focus_size",
                            "value"             		=> "30",
                            "min"               		=> "10",
                            "max"               		=> "100",
                            "step"              		=> "1",
                            "unit"              		=> 'px',
                            "description"       		=> "Define the font size to be used for the highlighted segments.",
                            "dependency"        		=> array( 'element' => "focus_custom", 'value' => 'true' ),
                            "group"						=> "Highlights Styling",
                        ),
						// Other Conditionals
						array(
							"type"              		=> "seperator",
							"param_name"        		=> "seperator_6",
							"seperator"					=> "Output Conditions",
							"group"						=> "Other Settings",
						),
						array(
							"type"              		=> "ts_conditionals",
							"heading"                   => __( "Output Conditions", "ts_visual_composer_extend" ),
							"param_name"        		=> "conditionals",
							"connector"					=> "restrictions",
							"group"						=> "Other Settings",
						),
						array(
							"type"                      => "hidden_input",
							"heading"                   => __( "Output Conditions", "ts_visual_composer_extend" ),
							"param_name"                => "restrictions",
							"value"                     => "",
							"admin_label"		        => true,
							"group"						=> "Other Settings",
						),	
                        // Other Settings
                        array(
                            "type"                      => "seperator",
                            "param_name"                => "seperator_7",
                            "seperator"			        => "Other Settings",
                            "group" 			        => "Other Settings",
                        ),
                        array(
                            "type"                      => "nouislider",
                            "heading"                   => __( "Margin: Top", "ts_visual_composer_extend" ),
                            "param_name"                => "margin_top",
                            "value"                     => "0",
                            "min"                       => "-50",
                            "max"                       => "500",
                            "step"                      => "1",
                            "unit"                      => 'px',
                            "description"               => __( "Select the top margin for the element.", "ts_visual_composer_extend" ),
                            "group" 			        => "Other Settings",
                        ),
                        array(
                            "type"                      => "nouislider",
                            "heading"                   => __( "Margin: Bottom", "ts_visual_composer_extend" ),
                            "param_name"                => "margin_bottom",
                            "value"                     => "0",
                            "min"                       => "-50",
                            "max"                       => "500",
                            "step"                      => "1",
                            "unit"                      => 'px',
                            "description"               => __( "Select the bottom margin for the element.", "ts_visual_composer_extend" ),
                            "group" 			        => "Other Settings",
                        ),
                        array(
                            "type"                      => "textfield",
                            "heading"                   => __( "Define ID Name", "ts_visual_composer_extend" ),
                            "param_name"                => "el_id",
                            "value"                     => "",
                            "description"               => __( "Enter an unique ID for the element.", "ts_visual_composer_extend" ),
                            "group" 			        => "Other Settings",
                        ),
                        array(
                            "type"				        => "tag_editor",
                            "heading"			        => __( "Extra Class Names", "ts_visual_composer_extend" ),
                            "param_name"		        => "el_class",
                            "value"				        => "",
                            "description"		        => __( "Enter additional class names for the element.", "ts_visual_composer_extend" ),
                            "group"				        => "Other Settings",
                        ),
                    )
                );	
                if ($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_LeanMap == "true") {
                    return $VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element;
                } else {			
                    vc_map($VISUAL_COMPOSER_EXTENSIONS->TS_VCSC_VisualComposer_Element);
                };
            }
        }
    }
	// Register Container and Child Shortcode with WP Bakery Page Builder
	if ((class_exists('WPBakeryShortCode')) && (!class_exists('WPBakeryShortCode_TS_VCSC_Highlighted_Textblock'))) {
		class WPBakeryShortCode_TS_VCSC_Highlighted_Textblock extends WPBakeryShortCode {};
	}
	// Initialize "TS Advanced Textblock Element" Class
	if (class_exists('TS_VCSC_TextBlock_Highlights_Element')) {
		$TS_VCSC_TextBlock_Highlights_Element = new TS_VCSC_TextBlock_Highlights_Element;
	}
?>